*
* PROJECT       : COMAU
* ROBOT NAME    : 'S-13-1.9' 
* CONTROLLER NAME : C5G
* DATE :	 30/05/2018
* UPDATES: 30/05/2018
* C5G SOFTWARE VERSION : 2.42.004
* C5G CONFIGURATION FILE : SX_01402.PDL
* Author: Dr. Lekbir Batali 
* Comau Robotics Business Line
* e-mail: lekbir.batali@comau.com

*
*
* DESCRIPTION   :
*

motion_space                space_comau;



cart_max_lin_speed			1500.0;
cart_basic_lin_speed		1500.0;
cart_max_lin_acc			1700.0;
cart_basic_lin_acc			1700.0;
cart_max_lin_dec			1700.0;
cart_basic_lin_dec			1700.0;
cart_max_rot_speed			   2.0;
cart_basic_rot_speed		   2.0;
cart_max_rot_acc               4.0;
cart_basic_rot_acc             4.0;
cart_max_rot_dec               4.0;
cart_basic_rot_dec             4.0;

cart_max_spin_speed			   			2.0;
cart_basic_spin_speed	       			2.0;
cart_max_spin_acc              			4.0;
cart_basic_spin_acc            			4.0;
cart_max_spin_dec              			4.0;
cart_basic_spin_dec            			4.0;
cart_max_roll_speed			   			2.0;
cart_basic_roll_speed		   			2.0;
cart_max_roll_acc                       4.0;
cart_basic_roll_acc                     4.0;
cart_max_roll_dec                       4.0;
cart_basic_roll_dec                     4.0;

gen_speed_override                      1.0;
gen_acc_override                        1.0;
gen_dec_override                        1.0;
gen_basic_joints_speed                  1.0;
gen_basic_joints_acc                    1.0;
gen_basic_joints_dec                    1.0;
cart_vel_prof                  max_acc_prof;
single_cart_prof                single_prof;
single_joint_prof               single_prof;
cart_orient              interpolate_orient;
reach_circ_via_point         reach_position;
interpolation_type         interpolate_by_2;
speeds_given                          given;
sync_ext_axes                      sync_ext;
joints_coordination            end_together;
joints_end_together      usual_end_together;
cart_motion_connection          superimpose;
joint_motion_connection         superimpose;
cart_joint_connection     joint_superimpose;
joint_cart_connection     joint_superimpose;
cart_speed_to_jnt_cnvrt          by_lim_jnt;
speed_lim_jnt		        		 1500.0;
react_on_speed_excess                recalc;
check_joints_speed                    check;
joint_limit_in_cart                    stop;

is_wait                                wait;
cart_wait_time                         0.05;
joint_wait_time                        0.03;
delay_at_begin                          0.0;
delay_at_end                            0.0;
cart_settle_time                        0.0;
angular_section                         5.0;
linear_section                         25.0;
epsilon_position                        5.0;
epsilon_orientation                     0.1;
max_no_of_divisions                       4;

config_family         cf_over_head_neg;
* 
* j3 joint_cf_sin_neg is not supported
* 
joint_config_family j3 joint_cf_neg;
joint_config_family j5 joint_cf_sin_pos;
use_config                         use;
gen_config_change     allow_config_change;
joint_config_change j3  allow_config_change;
joint_config_change j5  allow_config_change;

*
* Turns information
*
joint_is_turn       j4            turn;
joint_is_turn       j6            turn;
default_turns j4 0 -180.0, j6 0 -180.0;

default_motion_type             joints;
approach_vec                approach_z;
external_accelerations              -1;

*
* Zones:
*
zone_define  fine     no_smooth;
zone_define  medium   no_smooth;
zone_define  coarse   no_smooth;
zone_define  nodecel  speed joints 100 100 100 100 100 100;
*
* joint_settle is a simulation of $TOL_ABT
*
joint_settle         all      0.0;
joint_delay          all      0.200;

joint_speed_override all      1.0;
joint_acc_override   all      1.0;
joint_dec_override   all      1.0;
joint_vel_prof       all  max_acc_prof;

* Motor_max_speed  [rpm]           j1   5423.0;
* Tx_rate [Motor_turn/Axis_turn]    j1   -158.7;
joint_max_speed         j1       3.6; 
joint_basic_speed       j1       3.6; 
joint_max_acc 		j1       14.3; 
joint_basic_acc         j1       14.3; 
joint_max_dec           j1       14.3; 
joint_basic_dec         j1       14.3; 
joint_acc_time          j1       0.2; 
joint_dec_time          j1       0.2; 

joints_limits           j1       -180  180;

* Motor_max_speed  [rpm]           j2   5376.0;
* Tx_rate [Motor_turn/Axis_turn]    j2   179.2;
joint_max_speed         j2       3.1; 
joint_basic_speed       j2       3.1; 
joint_max_acc 		j2       12.6; 
joint_basic_acc         j2       12.6; 
joint_max_dec           j2       12.6; 
joint_basic_dec         j2       12.6; 
joint_acc_time          j2       0.2; 
joint_dec_time          j2       0.2; 

* joints_limits           j2       -90  160;

* Motor_max_speed  [rpm]           j3   5590.0;
* Tx_rate [Motor_turn/Axis_turn]    j3   129.0;
joint_max_speed         j3       4.5; 
joint_basic_speed       j3       4.5; 
joint_max_acc 		j3       30.3; 
joint_basic_acc         j3       30.3; 
joint_max_dec           j3       30.3; 
joint_basic_dec         j3       30.3; 
joint_acc_time          j3       0.1; 
joint_dec_time          j3       0.1; 

* joints_limits           j3       -170  120;

* Motor_max_speed  [rpm]           j4   5959.0;
* Tx_rate [Motor_turn/Axis_turn]    j4   84.1;
joint_max_speed         j4       7.4; 
joint_basic_speed       j4       7.4; 
joint_max_acc 		    j4       49.5; 
joint_basic_acc         j4       49.5; 
joint_max_dec           j4       49.5; 
joint_basic_dec         j4       49.5; 
joint_acc_time          j4       0.1; 
joint_dec_time          j4       0.1; 

joints_limits           j4       -200  200;

* Motor_max_speed  [rpm]           j5   5400.0;
* Tx_rate [Motor_turn/Axis_turn]    j5   81.0;
joint_max_speed         j5       7.0; 
joint_basic_speed       j5       7.0; 
joint_max_acc 		j5       46.5; 
joint_basic_acc         j5       46.5; 
joint_max_dec           j5       46.5; 
joint_basic_dec         j5       46.5; 
joint_acc_time          j5       0.1; 
joint_dec_time          j5       0.1; 

joints_limits           j5       -125  125;

* Motor_max_speed  [rpm]           j6   5982.0;
* Tx_rate [Motor_turn/Axis_turn]    j6   -56.1;
joint_max_speed         j6       11.2; 
joint_basic_speed       j6       11.2; 
joint_max_acc 		j6       55.9; 
joint_basic_acc         j6       55.9; 
joint_max_dec           j6       55.9; 
joint_basic_dec         j6       55.9; 
joint_acc_time          j6       0.2; 
joint_dec_time          j6       0.2; 

joints_limits           j6       -200  200;

*                 Speed_rpm * 2 * Pi_greco		
* Motor_Speed = ------------------------------------	
*                        Tx_rate * 60			
*							
*                   Motor_Speed			
* Motor_Acc   = -------------------			
*                      T_Acc				
*							
*							
* End of file						
